<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Response;

class HtmlMinifier
{
    public function handle($request, Closure $next)
    {
  
        $response = $next($request);


        if (!env('APP_ENV') == 'local'){
            $contentType = $response->headers->get('Content-Type');
            if (strpos($contentType, 'text/html') !== false) {
                $response->setContent($this->minify($response->getContent()));
            }
        }

        return $response;

    }

    public function minify($input)
    {
        $search = [
            '/\>\s+/s',
            '/\s+</s',
        ];

        $replace = [
            '> ',
            ' <',
        ];

        return preg_replace($search, $replace, $input);
    }
}