import { createI18n } from 'vue-i18n';
import languages from '@lang/lang.json';

export const LANGUAGES = languages.available;
export const SUPPORT_LOCALES = languages.available.map(l => l.value);

const i18n = createI18n({
  missingWarn: false,
  fallbackWarn: false,
  fallbackLocale: 'en',
  warnHtmlMessage: false,
  locale: window.Locale || 'en',
});

export default i18n;
